package org.msh.etbm.rest.export;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.etbm.commons.apidoc.annotations.ApiDoc;
import org.msh.etbm.commons.apidoc.annotations.ApiDocMethod;
import org.msh.etbm.rest.authentication.Authenticated;
import org.msh.etbm.rest.commons.StandardResult;
import org.msh.tb.export_rest.cases.CaseExportRequest;
import org.msh.tb.export_rest.cases.CasesExcelExportService;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * API to download an Excel file containing exported cases
 * <p>
 * Created by rmemoria on 13/7/17.
 */
@ApiDoc(summary = "Exportar casos para planilha Excel", group = "Reports")
@Name("caseExportREST")
@Path("/cases/export")
@Authenticated(permissions = {"EXPORT"})
public class CaseExportREST {

    @In
    CasesExcelExportService casesExcelExportService;


    @Path("/init")
    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    @ApiDocMethod(summary = "Inicia processo para exportação dos casos para um arquivo Excel")
    public StandardResult initExport(CaseExportRequest req) {
        String taskId = casesExcelExportService.initExport(req);

        return StandardResult.success(taskId);
    }

}
